﻿using System;
using NetOffice;
using NetOffice.Attributes;
namespace NetOffice.ExcelApi.Enums
{
	 /// <summary>
	 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
	 /// </summary>
	 ///<remarks> MSDN Online Documentation: http://msdn.microsoft.com/en-us/en-us/library/office/ff194519.aspx </remarks>
	[SupportByVersion("Excel", 9,10,11,12,14,15,16)]
	[EntityType(EntityType.IsEnum)]
	public enum XlBuiltInDialog
	{
		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogOpen = 1,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogOpenLinks = 2,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>5</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSaveAs = 5,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>6</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFileDelete = 6,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>7</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPageSetup = 7,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>8</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPrint = 8,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>9</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPrinterSetup = 9,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>12</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogArrangeAll = 12,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>13</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWindowSize = 13,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>14</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWindowMove = 14,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>17</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogRun = 17,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>23</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSetPrintTitles = 23,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>26</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFont = 26,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>27</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogDisplay = 27,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>28</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogProtectDocument = 28,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>32</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogCalculation = 32,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>35</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogExtract = 35,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>36</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogDataDelete = 36,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>39</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSort = 39,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>40</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogDataSeries = 40,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>41</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogTable = 41,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>42</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFormatNumber = 42,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>43</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogAlignment = 43,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>44</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogStyle = 44,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>45</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogBorder = 45,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>46</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogCellProtection = 46,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>47</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogColumnWidth = 47,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>52</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogClear = 52,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>53</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPasteSpecial = 53,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>54</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogEditDelete = 54,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>55</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogInsert = 55,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>58</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPasteNames = 58,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>61</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogDefineName = 61,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>62</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogCreateNames = 62,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>63</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFormulaGoto = 63,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>64</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFormulaFind = 64,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>67</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGalleryArea = 67,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>68</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGalleryBar = 68,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>69</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGalleryColumn = 69,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>70</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGalleryLine = 70,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>71</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGalleryPie = 71,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>72</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGalleryScatter = 72,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>73</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogCombination = 73,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>76</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGridlines = 76,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>78</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogAxes = 78,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>80</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogAttachText = 80,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>84</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPatterns = 84,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>85</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogMainChart = 85,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>86</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogOverlay = 86,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>87</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogScale = 87,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>88</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFormatLegend = 88,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>89</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFormatText = 89,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>91</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogParse = 91,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>94</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogUnhide = 94,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>95</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWorkspace = 95,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>103</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogActivate = 103,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>108</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogCopyPicture = 108,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>110</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogDeleteName = 110,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>111</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogDeleteFormat = 111,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>119</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogNew = 119,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>127</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogRowHeight = 127,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>128</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFormatMove = 128,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>129</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFormatSize = 129,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>130</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFormulaReplace = 130,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>132</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSelectSpecial = 132,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>133</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogApplyNames = 133,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>134</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogReplaceFont = 134,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>137</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSplit = 137,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>142</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogOutline = 142,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>145</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSaveWorkbook = 145,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>147</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogCopyChart = 147,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>150</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFormatFont = 150,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>154</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogNote = 154,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>159</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSetUpdateStatus = 159,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>161</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogColorPalette = 161,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>166</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogChangeLink = 166,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>170</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogAppMove = 170,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>171</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogAppSize = 171,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>185</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogMainChartType = 185,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>186</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogOverlayChartType = 186,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>188</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogOpenMail = 188,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>189</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSendMail = 189,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>190</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogStandardFont = 190,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>191</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogConsolidate = 191,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>192</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSortSpecial = 192,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>193</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGallery3dArea = 193,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>194</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGallery3dColumn = 194,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>195</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGallery3dLine = 195,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>196</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGallery3dPie = 196,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>197</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogView3d = 197,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>198</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGoalSeek = 198,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>199</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWorkgroup = 199,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>200</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFillGroup = 200,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>201</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogUpdateLink = 201,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>202</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPromote = 202,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>203</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogDemote = 203,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>204</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogShowDetail = 204,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>207</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogObjectProperties = 207,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>208</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSaveNewObject = 208,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>212</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogApplyStyle = 212,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>213</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogAssignToObject = 213,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>214</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogObjectProtection = 214,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>217</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogCreatePublisher = 217,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>218</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSubscribeTo = 218,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>220</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogShowToolbar = 220,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>222</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPrintPreview = 222,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>223</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogEditColor = 223,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>225</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFormatMain = 225,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>226</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFormatOverlay = 226,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>228</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogEditSeries = 228,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>229</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogDefineStyle = 229,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>249</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGalleryRadar = 249,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>251</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogEditionOptions = 251,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>256</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogZoom = 256,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>259</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogInsertObject = 259,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>261</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSize = 261,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>262</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogMove = 262,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>269</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFormatAuto = 269,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>272</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGallery3dBar = 272,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>273</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGallery3dSurface = 273,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>276</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogCustomizeToolbar = 276,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>281</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWorkbookAdd = 281,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>282</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWorkbookMove = 282,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>283</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWorkbookCopy = 283,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>284</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWorkbookOptions = 284,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>285</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSaveWorkspace = 285,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>288</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogChartWizard = 288,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>293</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogAssignToTool = 293,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>300</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPlacement = 300,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>301</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFillWorkgroup = 301,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>302</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWorkbookNew = 302,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>305</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogScenarioCells = 305,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>307</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogScenarioAdd = 307,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>308</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogScenarioEdit = 308,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>311</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogScenarioSummary = 311,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>312</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPivotTableWizard = 312,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>313</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPivotFieldProperties = 313,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>318</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogOptionsCalculation = 318,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>319</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogOptionsEdit = 319,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>320</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogOptionsView = 320,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>321</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogAddinManager = 321,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>322</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogMenuEditor = 322,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>323</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogAttachToolbars = 323,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>325</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogOptionsChart = 325,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>328</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogVbaInsertFile = 328,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>330</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogVbaProcedureDefinition = 330,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>336</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogRoutingSlip = 336,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>339</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogMailLogon = 339,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>342</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogInsertPicture = 342,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>344</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGalleryDoughnut = 344,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>350</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogChartTrend = 350,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>354</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWorkbookInsert = 354,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>355</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogOptionsTransition = 355,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>356</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogOptionsGeneral = 356,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>370</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFilterAdvanced = 370,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>378</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogMailNextLetter = 378,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>379</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogDataLabel = 379,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>380</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogInsertTitle = 380,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>381</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFontProperties = 381,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>382</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogMacroOptions = 382,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>384</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWorkbookUnhide = 384,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>386</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWorkbookName = 386,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>388</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogGalleryCustom = 388,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>390</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogAddChartAutoformat = 390,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>392</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogChartAddData = 392,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>394</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogTabOrder = 394,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>398</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSubtotalCreate = 398,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>415</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWorkbookTabSplit = 415,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>417</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWorkbookProtect = 417,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>420</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogScrollbarProperties = 420,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>421</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPivotShowPages = 421,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>422</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogTextToColumns = 422,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>423</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFormatCharttype = 423,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>433</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPivotFieldGroup = 433,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>434</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPivotFieldUngroup = 434,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>435</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogCheckboxProperties = 435,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>436</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogLabelProperties = 436,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>437</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogListboxProperties = 437,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>438</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogEditboxProperties = 438,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>441</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogOpenText = 441,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>445</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPushbuttonProperties = 445,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>447</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFilter = 447,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>450</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFunctionWizard = 450,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>456</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSaveCopyAs = 456,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>458</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogOptionsListsAdd = 458,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>460</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSeriesAxes = 460,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>461</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSeriesX = 461,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>462</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSeriesY = 462,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>463</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogErrorbarX = 463,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>464</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogErrorbarY = 464,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>465</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFormatChart = 465,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>466</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSeriesOrder = 466,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>470</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogMailEditMailer = 470,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>472</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogStandardWidth = 472,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>473</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogScenarioMerge = 473,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>474</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogProperties = 474,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>474</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSummaryInfo = 474,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>475</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFindFile = 475,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>476</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogActiveCellFont = 476,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>478</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogVbaMakeAddin = 478,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>481</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogFileSharing = 481,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>485</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogAutoCorrect = 485,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>493</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogCustomViews = 493,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>496</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogInsertNameLabel = 496,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>504</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSeriesShape = 504,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>505</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogChartOptionsDataLabels = 505,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>506</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogChartOptionsDataTable = 506,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>509</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSetBackgroundPicture = 509,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>525</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogDataValidation = 525,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>526</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogChartType = 526,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>527</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogChartLocation = 527,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>538</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 _xlDialogPhonetic = 538,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>540</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogChartSourceData = 540,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>541</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 _xlDialogChartSourceData = 541,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>557</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogSeriesOptions = 557,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>567</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPivotTableOptions = 567,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>568</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPivotSolveOrder = 568,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>570</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPivotCalculatedField = 570,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>572</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPivotCalculatedItem = 572,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>583</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogConditionalFormatting = 583,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>596</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogInsertHyperlink = 596,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>620</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogProtectSharing = 620,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>647</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogOptionsME = 647,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>653</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPublishAsWebPage = 653,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>656</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPhonetic = 656,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>667</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogNewWebQuery = 667,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>666</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogImportTextFile = 666,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>530</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogExternalDataProperties = 530,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>683</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWebOptionsGeneral = 683,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>684</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWebOptionsFiles = 684,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>685</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWebOptionsPictures = 685,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>686</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWebOptionsEncoding = 686,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>687</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogWebOptionsFonts = 687,

		 /// <summary>
		 /// SupportByVersion Excel 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>689</remarks>
		 [SupportByVersion("Excel", 9,10,11,12,14,15,16)]
		 xlDialogPivotClientServerSet = 689,

		 /// <summary>
		 /// SupportByVersion Excel 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>754</remarks>
		 [SupportByVersion("Excel", 10,11,12,14,15,16)]
		 xlDialogPropertyFields = 754,

		 /// <summary>
		 /// SupportByVersion Excel 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>731</remarks>
		 [SupportByVersion("Excel", 10,11,12,14,15,16)]
		 xlDialogSearch = 731,

		 /// <summary>
		 /// SupportByVersion Excel 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>709</remarks>
		 [SupportByVersion("Excel", 10,11,12,14,15,16)]
		 xlDialogEvaluateFormula = 709,

		 /// <summary>
		 /// SupportByVersion Excel 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>723</remarks>
		 [SupportByVersion("Excel", 10,11,12,14,15,16)]
		 xlDialogDataLabelMultiple = 723,

		 /// <summary>
		 /// SupportByVersion Excel 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>724</remarks>
		 [SupportByVersion("Excel", 10,11,12,14,15,16)]
		 xlDialogChartOptionsDataLabelMultiple = 724,

		 /// <summary>
		 /// SupportByVersion Excel 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>732</remarks>
		 [SupportByVersion("Excel", 10,11,12,14,15,16)]
		 xlDialogErrorChecking = 732,

		 /// <summary>
		 /// SupportByVersion Excel 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>773</remarks>
		 [SupportByVersion("Excel", 10,11,12,14,15,16)]
		 xlDialogWebOptionsBrowsers = 773,

		 /// <summary>
		 /// SupportByVersion Excel 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>796</remarks>
		 [SupportByVersion("Excel", 11,12,14,15,16)]
		 xlDialogCreateList = 796,

		 /// <summary>
		 /// SupportByVersion Excel 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>832</remarks>
		 [SupportByVersion("Excel", 11,12,14,15,16)]
		 xlDialogPermission = 832,

		 /// <summary>
		 /// SupportByVersion Excel 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>834</remarks>
		 [SupportByVersion("Excel", 11,12,14,15,16)]
		 xlDialogMyPermission = 834,

		 /// <summary>
		 /// SupportByVersion Excel 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>862</remarks>
		 [SupportByVersion("Excel", 12,14,15,16)]
		 xlDialogDocumentInspector = 862,

		 /// <summary>
		 /// SupportByVersion Excel 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>977</remarks>
		 [SupportByVersion("Excel", 12,14,15,16)]
		 xlDialogNameManager = 977,

		 /// <summary>
		 /// SupportByVersion Excel 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>978</remarks>
		 [SupportByVersion("Excel", 12,14,15,16)]
		 xlDialogNewName = 978,

		 /// <summary>
		 /// SupportByVersion Excel 14, 15, 16
		 /// </summary>
		 /// <remarks>1133</remarks>
		 [SupportByVersion("Excel", 14,15,16)]
		 xlDialogSparklineInsertLine = 1133,

		 /// <summary>
		 /// SupportByVersion Excel 14, 15, 16
		 /// </summary>
		 /// <remarks>1134</remarks>
		 [SupportByVersion("Excel", 14,15,16)]
		 xlDialogSparklineInsertColumn = 1134,

		 /// <summary>
		 /// SupportByVersion Excel 14, 15, 16
		 /// </summary>
		 /// <remarks>1135</remarks>
		 [SupportByVersion("Excel", 14,15,16)]
		 xlDialogSparklineInsertWinLoss = 1135,

		 /// <summary>
		 /// SupportByVersion Excel 14, 15, 16
		 /// </summary>
		 /// <remarks>1179</remarks>
		 [SupportByVersion("Excel", 14,15,16)]
		 xlDialogSlicerSettings = 1179,

		 /// <summary>
		 /// SupportByVersion Excel 14, 15, 16
		 /// </summary>
		 /// <remarks>1182</remarks>
		 [SupportByVersion("Excel", 14,15,16)]
		 xlDialogSlicerCreation = 1182,

		 /// <summary>
		 /// SupportByVersion Excel 14, 15, 16
		 /// </summary>
		 /// <remarks>1184</remarks>
		 [SupportByVersion("Excel", 14,15,16)]
		 xlDialogSlicerPivotTableConnections = 1184,

		 /// <summary>
		 /// SupportByVersion Excel 14, 15, 16
		 /// </summary>
		 /// <remarks>1183</remarks>
		 [SupportByVersion("Excel", 14,15,16)]
		 xlDialogPivotTableSlicerConnections = 1183,

		 /// <summary>
		 /// SupportByVersion Excel 14, 15, 16
		 /// </summary>
		 /// <remarks>1153</remarks>
		 [SupportByVersion("Excel", 14,15,16)]
		 xlDialogPivotTableWhatIfAnalysisSettings = 1153,

		 /// <summary>
		 /// SupportByVersion Excel 14, 15, 16
		 /// </summary>
		 /// <remarks>1109</remarks>
		 [SupportByVersion("Excel", 14,15,16)]
		 xlDialogSetManager = 1109,

		 /// <summary>
		 /// SupportByVersion Excel 14, 15, 16
		 /// </summary>
		 /// <remarks>1208</remarks>
		 [SupportByVersion("Excel", 14,15,16)]
		 xlDialogSetMDXEditor = 1208,

		 /// <summary>
		 /// SupportByVersion Excel 14, 15, 16
		 /// </summary>
		 /// <remarks>1107</remarks>
		 [SupportByVersion("Excel", 14,15,16)]
		 xlDialogSetTupleEditorOnRows = 1107,

		 /// <summary>
		 /// SupportByVersion Excel 14, 15, 16
		 /// </summary>
		 /// <remarks>1108</remarks>
		 [SupportByVersion("Excel", 14,15,16)]
		 xlDialogSetTupleEditorOnColumns = 1108,

		 /// <summary>
		 /// SupportByVersion Excel 15,16
		 /// </summary>
		 /// <remarks>1271</remarks>
		 [SupportByVersion("Excel", 15, 16)]
		 xlDialogManageRelationships = 1271,

		 /// <summary>
		 /// SupportByVersion Excel 15,16
		 /// </summary>
		 /// <remarks>1272</remarks>
		 [SupportByVersion("Excel", 15, 16)]
		 xlDialogCreateRelationship = 1272,

		 /// <summary>
		 /// SupportByVersion Excel 15,16
		 /// </summary>
		 /// <remarks>1258</remarks>
		 [SupportByVersion("Excel", 15, 16)]
		 xlDialogRecommendedPivotTables = 1258
	}
}